/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger.dangerous;

import com.wardanger.dangerous.DangerousConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Spider;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpiderSpeedEnhancement {
    private static final String SPIDER_BUFF_TAG = "dangerous_spider_buff";

    @SubscribeEvent
    public static void onSpiderSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Spider) {
            CompoundTag entityData;
            Spider spider = (Spider)entity;
            if (event.getLevel() instanceof ServerLevel && !(entityData = spider.getPersistentData()).m_128471_(SPIDER_BUFF_TAG)) {
                SpiderSpeedEnhancement.increaseSpiderSpeed(spider);
                entityData.m_128379_(SPIDER_BUFF_TAG, true);
            }
        }
    }

    private static void increaseSpiderSpeed(Spider spider) {
        double speedMultiplier = (Double)DangerousConfig.CONFIG.spiderSpeedMultiplier.get();
        AttributeInstance speedAttribute = spider.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null) {
            speedAttribute.m_22100_(speedAttribute.m_22115_() * speedMultiplier);
        }
    }
}

